class Position(object):
    def __init__(self, rank):
        self._rank = rank
        self._team = None
    @property
    def team(self):
        if self._team is None:
            if not self._rank.is_final():
                return None
            self._team = self._rank.position.team
        return self._team

class FilledPosition(object):
    def __init__(self, team):
        self._team = team
    @property
    def team(self):
        return self._team

class Rank(object):
    def __init__(self, is_final, position, rankinfo):
        self._is_final = is_final
        self._position = position
        self.rankinfo = rankinfo
    @property
    def position(self):
        return self._position
    @position.setter
    def position(self, new_position):
        assert not self._is_final
        self._position = new_position
    def is_final(self):
        return self._is_final
    def make_final(self):
        assert not self._is_final
        self._is_final = True

